#include "hal_data.h"
#include "dcds.h"
#include <realityai/finger_friction_workshop_model.h>

volatile int g_dc_callback;

static uint32_t g_events = 0;
static rai_data_collector_frame_buffer_t g_frame_buf[8];
rai_data_collector_callback_args_t g_callback_args;

extern float g_f4_phase_err_monitor;

// data collector is done, notify main loop
void rai_data_collector0_callback(const rai_data_collector_callback_args_t *p_args){
    g_callback_args.frame_buf_len = p_args->frame_buf_len;
    g_callback_args.frames = p_args->frames;
    g_callback_args.instance_id = p_args->instance_id;
    for(uint8_t i = 0; i < p_args->frames; i++){
        g_frame_buf[i] = p_args->p_frame_buf[i];
    }
    g_callback_args.p_frame_buf = g_frame_buf;
    g_dc_callback = 1;
}

void rai_data_collector0_error_callback(const rai_data_collector_error_callback_args_t *p_args)
{
    (void)p_args;
    dbg_assert(0); // start debugging!
}

#if DCDS_ENABLE_SHIPPER
// data shipper completed transmission of frame
void rai_data_shipper0_callback(rai_data_shipper_callback_args_t *p_args)
{
    dbg_assert(p_args->result == RM_COMMS_EVENT_TX_OPERATION_COMPLETE );
    RM_RAI_DATA_COLLECTOR_BufferRelease(&g_rai_data_collector0_ctrl);
}
#endif

void dcds_init(void)
{
    fsp_err_t rc = FSP_SUCCESS;
    g_dc_callback = 0;
#if DCDS_ENABLE_SHIPPER
    rc = RM_RAI_DATA_SHIPPER_Open(&g_rai_data_shipper0_ctrl, &g_rai_data_shipper0_cfg);
    dbg_assert(rc == FSP_SUCCESS);
#endif
    rc = RM_RAI_DATA_COLLECTOR_Open(&g_rai_data_collector0_ctrl, &g_rai_data_collector0_cfg);
    dbg_assert(rc == FSP_SUCCESS);

    rc = RM_RAI_DATA_COLLECTOR_SnapshotChannelRegister(&g_rai_data_collector0_ctrl, 0, &g_f4_phase_err_monitor);
    dbg_assert(rc == FSP_SUCCESS);

}

// ships that frame when collector is done
int dcds_sync(void)
{
    struct rai_model_struct* p_model = get_finger_friction_workshop_model();
    fsp_err_t rc = FSP_SUCCESS;
#if DCDS_ENABLE_SHIPPER
    rai_data_shipper_write_params_t arg;
    arg.diagnostic_data_len = RealityAI_get_monitor_data_size(p_model);
    arg.events = (uint16_t)g_events;
    arg.p_diagnostic_data = RealityAI_get_monitor_data(p_model);
    arg.p_sensor_data = &g_callback_args;
    rc = RM_RAI_DATA_SHIPPER_Write(&g_rai_data_shipper0_ctrl, &arg);
#else
    rc = RM_RAI_DATA_COLLECTOR_BufferRelease(&g_rai_data_collector0_ctrl);
#endif
    dbg_assert(rc == FSP_SUCCESS);

    g_dc_callback = 0;
    return (rc == FSP_SUCCESS) ? 0 : -1;
}

void dcds_start_snapshot(void){
    fsp_err_t rc = FSP_SUCCESS;
    rc = RM_RAI_DATA_COLLECTOR_SnapshotStart(&g_rai_data_collector0_ctrl);
    dbg_assert(rc == FSP_SUCCESS);
}

void dcds_stop_snapshot(void){
    fsp_err_t rc = FSP_SUCCESS;
    rc = RM_RAI_DATA_COLLECTOR_SnapshotStop(&g_rai_data_collector0_ctrl);
    dbg_assert(rc == FSP_SUCCESS);
}

