/* Code provided by Reality AI */
/* 
    Generated by Reality AI Tools
    Date            : 01/23/2025, 22:06:21
    Account         : NA
    Project         : NA
    H2Go Version    : 1.7
    Hopper Version  : 1.570
    Target Proc     : VOICE-RA6E1
    Model Type      : RAI_SVM_CLASSIFIER
    User Data Type  : int16
    Window Length   : 4096
    Channel Count   : 1
    Class Map       : [no_results: 0, everything_else: 1, glass_break: 2]
    Segmentation    : None
    Smoothing       : None

    Copyright (c) Renesas of America, Inc.  All rights reserved.
    Use and distribution are subject to applicable contract restrictions.
*/

/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include "glass_break_lsp_v2_model.h"
#ifdef __linux__
#include <unistd.h>
#endif

#define APPLY_SOFTMAX  1

static int16_t inputData[glass_break_lsp_v2_SAMPLES_PER_CHANNEL * glass_break_lsp_v2_NUM_CHANNELS];
static float conf_scores[glass_break_lsp_v2_NUM_CLASSES];  /* confidence scores */

int example_main(void)
{
    /* Init Your board and hardware here. */

    /* Example code loop
    *  Enter an infinite loop, simply generates a random vector of input and then attempt to classify it,
    *  printing the result. Replace this with your actual data read and windowing process.
    */

    while(1){
        /*
         * Fetch next data input window from your device.
         * Sensor data is simulated in this loop. Multi-channel windows are constructed for single event classification.
         *
         * Expected format of sensor data stream:
         * ch0[0],ch0[1],...,ch0[N-1], ch1[0],ch1[1],...,ch1[N-1], ... where N is SAMPLES_PER_CHANNEL (Window Length)
         * REPLACE THIS BLOCK WITH INPUT FROM YOUR DEVICE
        */
        for(size_t sample = 0; sample < glass_break_lsp_v2_SAMPLES_PER_CHANNEL; sample++){
            for(size_t channel = 0; channel < glass_break_lsp_v2_NUM_CHANNELS; channel++){
                int16_t r = (rand() % 64000) - 32000;
                inputData[channel*glass_break_lsp_v2_SAMPLES_PER_CHANNEL+sample] = r;
            }
        }
    
        /* Classify the input data */
        glass_break_lsp_v2_AICLASS AIC = glass_break_lsp_v2_predict(inputData);

        /* Convert class score to confidence score (CS) */
        RealityAI_get_class_scores(conf_scores, glass_break_lsp_v2_NUM_CLASSES, APPLY_SOFTMAX, get_glass_break_lsp_v2_model());

        /* Decode classification event using class names */
		switch(AIC){
		case(glass_break_lsp_v2_no_results):
			printf("Detected Class: no_results\n");
			break;
		case(glass_break_lsp_v2_everything_else):
			printf("Detected Class: everything_else [%.2f]\n", conf_scores[0]);
			break;
		case(glass_break_lsp_v2_glass_break):
			printf("Detected Class: glass_break [%.2f]\n", conf_scores[1]);
			break;
		};

        /* throttle execution speed */
    #ifdef __linux__
        sleep(1);
    #endif
  }
  return 0;
}
