**Renesas RealityAI Finger Friction Workshop on the MCK-RA6T2**

Refer to installation guide and tutorial document/ app note for details on the workshop.

**Project Environment**\
e2 studio version: 2024-10 or later (project tested with 2024-10 & 2025-01)\
FSP version: 5.6\
Device: MCK-RA6T2\

**Project Description**\
This workshop has been developed to showcase how to train a Reality AI classifier from collecting data within e2 studio, 
to building and exporting an ML model from Reality AI Tools. The project reads current values directly from the onboard
ADC at a sample rate of 1000Hz, it then inferes over the collected data to determine if the motor shaft is freely spinning
or if a friction force is applied to the shaft. If friction is detected, the three on board user LEDs are illuminated, 
otherwise the three LEDs remain off. Data acquisition and transmission is handled by the data collector and 
shipper modules, which are provided by the FSP. The data collector is configured in the snapshot mode, in this mode the
data collector automatically acquires samples in the background and notifies the program that a buffer is ready for 
transmission/inference. To avoid issues during transmission/inference the data collector uses a ping-pong buffer for
its internal buffering, and will return the full buffer upon submission. Once a buffer is ready to be transmitted,
the data shipper begins transmission by first sending a header and then the data buffer. Data transmission occurs on
channel 9 of the device (associated with header CN10) at a baudrate of 115200 baud, further details on the UART configuration
can be found below.

**How to Run the Project**\
Before you may get started with the workshop, you will need to regenerate required project content within the 
FSP configuration view.

**Enabling/Disabling UART Output**\
The toggle for UART transmission is labelled as DCDS_ENABLE_SHIPPER and can be found at the top of dcds.h.

**Debug Configuration**\
When first launching the debugger, the debugger configuration must be set. When prompted select "Renesas GDB Hardware 
Debugging" then "J-Link ARM" in the next menu. Finally, type in "R7FA6T2BD" for the device ID.

**UART Configuration**\
Channel: 9\
Data Bits: 8\
Parity: None\
Stop Bits: 1\
Baud Rate: 115200

Header CN10:
Pin[4]-> VCC   (no connection)\
Pin[3]-> TX    to RX (Green wire)\
Pin[2]-> RX     to TX (White wire)\
Pin[1]-> GND    to GND (Black wire)
