/***********************************************************************************************************************
* File Name    : r_mtr_control_parameter.h
* Description  : Definition of default control parameters for sensorless speed control
***********************************************************************************************************************/
/* Guard against multiple inclusion */
#ifndef R_MTR_CONTROL_PARAMETER_H
#define R_MTR_CONTROL_PARAMETER_H

/***********************************************************************************************************************
* Macro definitions  
***********************************************************************************************************************/
#define    MTR_CONTROL_PARAMETER     (1)

/* Target control parameter definitions */
#define    CP_CURRENT_OMEGA          (200.0f)   /* Natural frequency for current loop */
#define    CP_CURRENT_ZETA           (1.0f)     /* Damping ratio for current loop */
#define    CP_SPEED_OMEGA            (3.0f)     /* Natural frequency for speed loop */
#define    CP_SPEED_ZETA             (1.0f)     /* Damping ratio for speed loop */
#define    CP_E_OBS_OMEGA            (1000.0f)  /* Natural frequency of BEMF observer */
#define    CP_E_OBS_ZETA             (1.0f)     /* Damping ratio of BEMF observer */
#define    CP_PLL_EST_OMEGA          (20.0f)    /* Natural frequency of PLL Speed estimate loop */
#define    CP_PLL_EST_ZETA           (1.0f)     /* Damping ratio of PLL Speed estimate loop */
#define    CP_ID_DOWN_SPEED_RPM      (500.0f)   /* Speed to start decreasing id [rpm]  (mechanical) */
#define    CP_ID_UP_SPEED_RPM        (400.0f)   /* Speed to start increasing id [rpm]  (mechanical) */
#define    CP_MAX_SPEED_RPM          (2400.0f)  /* Maximum speed[rpm] (mechanical) */
#define    CP_OVERSPEED_LIMIT_RPM    (4500.0f)  /* Over speed limit [rpm] (mechanical) */
#define    CP_OL_ID_REF              (0.3f)     /* Id reference when low speed [A] */
                                                                                
#endif /* R_MTR_CONTROL_PARAMETER_H */                                          
