/*
* Copyright (c) 2020 - 2024 Renesas Electronics Corporation and/or its affiliates
*
* SPDX-License-Identifier: BSD-3-Clause
*/

/***********************************************************************************************************************
 * File Name    : board.h
 * Description  : Includes and API function available for this board.
 **********************************************************************************************************************/

/*******************************************************************************************************************//**
 * @ingroup BOARDS
 * @defgroup BOARD_RA6T2_MCK
 * @brief BSP for the RA6T2_MCK Board
 *
 * The RA6T2_MCK is a development kit for the Renesas RA6T2 microcontroller.
 *
 * @{
 **********************************************************************************************************************/

#ifndef BOARD_H
#define BOARD_H

/***********************************************************************************************************************
 * Includes   <System Includes> , "Project Includes"
 **********************************************************************************************************************/

/* BSP Board Specific Includes. */
#include "board_init.h"
#include "board_leds.h"

/***********************************************************************************************************************
 * Macro definitions
 **********************************************************************************************************************/
#define BOARD_RA6T2_MCK

/***********************************************************************************************************************
 * Typedef definitions
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * Exported global variables
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * Exported global functions (to be accessed by other files)
 **********************************************************************************************************************/

/** @} (end defgroup BSP_CONFIG_RA6T2) */

#endif
